%Matt Bristow
%27/01/2018

function [output] = FileOverWriteCheck(FileName)
    %SUMMARY: Function that checks to see if a file exists, and if it does
    %asks the user if they wish to over-write it.
        
    val = exist(FileName,'file');
    
    if(val == 2)
        Message = strcat('The file "',FileName,'" already exists.',...
            'Would you like to over-write it?');
        button = questdlg(Message,'Error!','Yes','No','No');
        switch button
            case 'Yes'; output = 1;
            case 'No'; output = 0;
        end
    else
        output = 1;
    end
end